/*

BSD License

Copyright (c) 2002, Brent Simmons
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

*	Redistributions of source code must retain the above copyright notice,
	this list of conditions and the following disclaimer.
*	Redistributions in binary form must reproduce the above copyright notice,
	this list of conditions and the following disclaimer in the documentation
	and/or other materials provided with the distribution.
*	Neither the name of ranchero.com or Brent Simmons nor the names of its
	contributors may be used to endorse or promote products derived
	from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


*/

/*
	SearchEngines.h
	Huevos

	Created by Brent Simmons on Wed Apr 03 2002.
	Copyright (c) 2002 Brent Simmons. All rights reserved.
*/


#import <Foundation/Foundation.h>


@interface SearchEngines : NSObject


+ (void) sendNotification;


/*Creating, deleting, editing*/

+ (void) new: (NSString *) name url: (NSString *) url;

+ (void) deleteNthSearchEngine: (int) n;

+ (void) setNthUrl: (NSString *) url n: (int) n;

+ (void) renameNthSearchEngine: (NSString *) name n: (int) n;


/*Getting info*/

+ (NSDictionary *) searchEnginesDictionary;	

+ (NSString *) urlFromName: (NSString *) name;	
	
+ (NSString *) nthSearchEngineUrl: (int) n;	
	
+ (NSString *) nthSearchEngineName: (int) n;

+ (int) indexOfSearchEngine: (NSString *) name;	
	
+ (NSArray *) arrayOfNames;

+ (int) count;


/*Command keys*/

+ (NSDictionary *) commandKeysDictionary;	

+ (NSString *) commandKeyForSearchEngine: (NSString *) name;	

+ (void) setCommandKeyForSearchEngine: (NSString *) cmdKey name: (NSString *) name;	

+ (void) setNthCommandKey: (NSString *) cmdKey n: (int) n;

+ (NSString *) nthSearchEngineCommandKey: (int) n;


@end
